using System;
using System.IO;
using System.Xml;
using System.Text;
using System.Diagnostics;
using System.Collections;

using Team_Project;
using Team_Project.Elements;
using Team_Project.PersistencyManagers;
using Team_Project.PersistencyManagers.Storages;
using Team_Project.PersistencyManagers.Protocols;

using Bertaccini.Utils;

namespace ProvaRemoting
{
	class Class1
	{
		public static TPEngine engine;
		[STAThread]
		static void Main(string[] args)
		{
			Trace.Listeners.Add(new TextWriterTraceListener(Console.Out));

			if(args.Length > 0)
			{
				Globals.Instance.LocalCopyName = args[0];
				Globals.Instance.Storages = new StorageManager(@"..\..\..\Config\Storages\"+args[0]+".xml",false);
				Globals.Instance.ListenPort = int.Parse(args[1]);
			}
		
			Trace.WriteLine("Starting copy: " + Globals.Instance.LocalCopyName);
			
			engine = new TPEngine();

			//RemotingConfiguration.Configure("ProvaRemoting.exe.config");
			Console.WriteLine("Listening for requests. Press Enter to exit...");
			Console.ReadLine();
			try
			{
				if(args.Length >= 3)
				{
					CopiesTreeManager ctm = (CopiesTreeManager)Globals.Instance.Data["TreeManager"];
					//TreeElement el = TreeElement.FromXmlNode(ctm.Tree.DocumentElement);
//					XmlDocument doc = el.ToXmlDocument();
//					doc.Save("C:\\Prova.xml");
//					ctm.AccessTeamProjectTree();
					System.Threading.Thread.Sleep(1000);
					switch(args[2].ToLower())
					{
						case "overr":
							OverrideTest();
							break;
						case "store":
							StoreTest();
							break;
						case "dirs":
							ListLocationsTest();
							break;
						case "info":
							FileInfoTest();
							break;
					}
				}
			}
			catch(Exception ecc)
			{
				Console.WriteLine("Terminating with an exception: " + ecc.Message);
				Console.WriteLine(ecc.StackTrace);
			}
			Console.WriteLine("Task finished. Press enter to exit...");
			Console.ReadLine();
			if(engine != null) engine.Dispose();
		}

		public static void OverrideTest()
		{
			LockElement le = new LockElement("PROVA","Locks","lockDiProva");
			le.LockerID = "Lock2di noder";
			IPersistencyProtocol pp = Globals.Instance.Protocols.GetProtocolFor("PROVA",typeof(LockElement),Direction.Store);
			if(!pp.QueryLocationExists("Locks"))
				pp.CreateLocation("Locks");
			pp.Store(le);
		}

		public static void FileInfoTest()
		{
string input ="<TeamProjectRequest>"
+"	<Authentication>"
+"		<UserName>Simo</UserName>"
+"		<Password>password</Password>"
+"	</Authentication>"
+"	<Project>"
+"		<Name>PROVA</Name>"
+"	</Project>"
+"	<Action>"
+"		<Code>GetFileInfo</Code>"
+"		<ActionParameters>"
+"	<FileInfo>"
+"		<FileName>tempo.exe.config</FileName>"
+"		<FilePath></FilePath>"
+"		<FileHash>CC2mN/yK/vknDAtemIeua9akPqY=</FileHash>"
+"	</FileInfo>"
+"		</ActionParameters>"
+"	</Action>"
+"</TeamProjectRequest>";
			XmlTextReader tr = new XmlTextReader(new StringReader(input));
			MsgElabChainManager mecm = (MsgElabChainManager)Globals.Instance.Data["ChainManager"];
			IOperationHandler oh = mecm.GetRoot();
			tr.WhitespaceHandling = WhitespaceHandling.None;
			Hashtable props = new Hashtable();
			bool ok;
			tr.Read();
			Stream res = oh.Compute(props,tr,out ok);
			StreamReader sr = new StreamReader(res);
			input = sr.ReadToEnd();
			Console.WriteLine(input);
		}

		public static void ListLocationsTest()
		{
			MemoryStream ms = new MemoryStream();
			StreamWriter sw = new StreamWriter(ms);
			sw.WriteLine("<TeamProjectRequest>");
			sw.WriteLine("	<Authentication>");
			sw.WriteLine("		<UserName>Simo</UserName>");
			sw.WriteLine("		<Password>password</Password>");
			sw.WriteLine("	</Authentication>");
			sw.WriteLine("	<Project>");
			sw.WriteLine("		<Name>PROVA</Name>");
			sw.WriteLine("	</Project>");
			sw.WriteLine("	<Action>");
			sw.WriteLine("		<Code>ListLocations</Code>");
			sw.WriteLine("		<ActionParameters>");
			sw.WriteLine("			<LocationInfo>");
			sw.WriteLine("				<LocationName>\\</LocationName>");
			sw.WriteLine("			</LocationInfo>");
			sw.WriteLine("		</ActionParameters>");
			sw.WriteLine("	</Action>");
			sw.WriteLine("</TeamProjectRequest>");
			sw.Flush();
			ms.Position = 0;
			TextReader txtrdr = new StreamReader(ms);
			MsgElabChainManager mecm = (MsgElabChainManager)Globals.Instance.Data["ChainManager"];
			IOperationHandler oh = mecm.GetRoot();
			XmlTextReader tr = new XmlTextReader(ms);
			tr.WhitespaceHandling = WhitespaceHandling.None;
			Hashtable props = new Hashtable();
			bool ok;
			tr.Read();
			Stream res = oh.Compute(props,tr,out ok);
			StreamReader sr = new StreamReader(res);
			Console.WriteLine(sr.ReadToEnd());

		}

		public static void StoreTest()
		{
			MemoryStream ms = new MemoryStream();
			StreamWriter sw = new StreamWriter(ms);
			sw.WriteLine("<TeamProjectRequest>");
			sw.WriteLine("	<Authentication>");
			sw.WriteLine("		<UserName>Simo</UserName>");
			sw.WriteLine("		<Password>password</Password>");
			sw.WriteLine("	</Authentication>");
			sw.WriteLine("	<Project>");
			sw.WriteLine("		<Name>PROVA</Name>");
			sw.WriteLine("	</Project>");
			sw.WriteLine("	<Action>");
			sw.WriteLine("		<Code>CreateLocation</Code>");
			sw.WriteLine("		<ActionParameters>");
			sw.WriteLine("			<LocationInfo>");
			sw.WriteLine("				<LocationName>ProvaDir</LocationName>");
			sw.WriteLine("			</LocationInfo>");
			sw.WriteLine("		</ActionParameters>");
			sw.WriteLine("	</Action>");
			sw.WriteLine("</TeamProjectRequest>");
			sw.Flush();
			ms.Position = 0;
			TextReader txtrdr = new StreamReader(ms);
//			ProvaRemoting.it.teamproject.service.WebInterface wi = new ProvaRemoting.it.teamproject.service.WebInterface();
//			wi.Discover();
//			string r = wi.PerformAction(txtrdr.ReadToEnd());
//			StringReader sr = new StringReader(r);
			MsgElabChainManager mecm = (MsgElabChainManager)Globals.Instance.Data["ChainManager"];
			IOperationHandler oh = mecm.GetRoot();
			XmlTextReader tr = new XmlTextReader(ms);
			tr.WhitespaceHandling = WhitespaceHandling.None;
			Hashtable props = new Hashtable();
			bool ok;
			tr.Read();
			Stream res = oh.Compute(props,tr,out ok);
			StreamReader sr = new StreamReader(res);
			Console.WriteLine(sr.ReadToEnd());

			ms = new MemoryStream();
			sw = new StreamWriter(ms);
			sw.WriteLine("<TeamProjectRequest>");
			sw.WriteLine("<Authentication>");
			sw.WriteLine("<UserName>Simo</UserName>");
			sw.WriteLine("<Password>password</Password>");
			sw.WriteLine("</Authentication>");
			sw.WriteLine("<Project>");
			sw.WriteLine("<Name>PROVA</Name>");
			sw.WriteLine("</Project>");
			sw.WriteLine("<Action>");
			sw.WriteLine("<Code>FileStore</Code>");
			sw.WriteLine("<ActionParameters>");
			sw.WriteLine("<FileInfo>");
			sw.WriteLine("<FileName>ProvaModule</FileName>");
			sw.WriteLine("<FilePath>ProvaDir</FilePath>");
			string FileContent = "Ciao sono Simone e questo  un bel file";
			byte[] c = Encoding.Default.GetBytes(FileContent);
			sw.WriteLine("<FileData>");
			sw.WriteLine(Convert.ToBase64String(c,0,c.Length));
			sw.WriteLine("</FileData>");
			sw.WriteLine("</FileInfo>");
			sw.WriteLine("</ActionParameters>");
			sw.WriteLine("</Action>");
			sw.WriteLine("</TeamProjectRequest>");
			sw.Flush();
			ms.Position = 0;
			tr = new XmlTextReader(ms);
			tr.WhitespaceHandling = WhitespaceHandling.None;
			tr.Read();
			res = oh.Compute(props,tr,out ok);
			sr = new StreamReader(res);
			txtrdr = new StreamReader(ms);
			//ProvaRemoting.it.teamproject.service.WebInterface wi = new ProvaRemoting.it.teamproject.service.WebInterface();
			//r = wi.PerformAction(txtrdr.ReadToEnd());
			//sr = new StringReader(r);
			Console.WriteLine(sr.ReadToEnd());
		}
	}
}
